//Copyright (c) 2000-2001 Microsoft Corporation.  All rights reserved.
//<script>
var g_WinDoc            =   window.document;
var g_WinDocAll         =   g_WinDoc.all;

/*
	expando Attributes used:
	
		sticky			Indicates a button that can be left depressed.
		submenu			String containing id of submenu to display on press.
		menuitem		Indicates that this is a menu selection.
		overelements	An item that raises when this button is selected.
		radio			This is a radio button and is a semicolon separated list
						of the other buttons.
		stickytoggle	This is like a radio button and is a semicolon separated
						list of the other buttons. It differs from a radio button
						in the fact that you can unselect all of them.
		swapitems		A list of items that flip visibility. hidden=>visible and vice versa
		buttondown		Indicates the current state of the button.
*/
function onDocumentMouseDown()
{
	if(event.srcElement.name != "cbButton")
	{
		f_CbMenuShow( null );
	}
}
function onDocumentMouseOut()
{
	if(null == event.toElement)
	{
		f_CbMenuShow( null );
	}
}
function f_onCbMouseOut()
{
	event.cancelBubble=true;
	if( null != this.sticky )		// If it is sticky
	{
		if( true == this.buttondown )
		{
			return;
		};
	}
	else if( null != this.menuitem)
	{
		return;
	}
	this.className= (true == this.raised) ? "tbButtonRaise" : "tbButton";
	this.onmouseout=null;
}
function f_onCbMouseUp(obj)
{
	event.cancelBubble=true;
	if( null != this.sticky )
	{
		if( true == this.buttondown )
		{
			return;
		};
	}
	else if( null != this.menuitem)
	{
		return;
	}
	this.className= (true == this.raised) ? "tbButtonRaise" : "tbButton";
	this.onmouseup=null;
}
function onCbMouseDown(obj)
{
	if( null != obj.menuitem )
	{
		return;
	}
	if( null != f_CbMenuShow.current && f_CbMenuShow.current != obj && true != obj.raised )
	{
		f_CbMenuShow( null );
	}
	obj.className="tbButtonDown";
	obj.onmouseout = f_onCbMouseOut;
	obj.onmouseup = f_onCbMouseUp;
}
function onCbClickEvent(obj, fNoEvent)
{
	if( null != event )
	{
		event.cancelBubble=true;
	}

	// If the item is on a menu.
	if(null != obj.menuitem)
	{
		onCbClick(obj.id, true)
		f_CbMenuShow( null );		// Hide the menu;
		return(false);
	}

	// Sticking Button
	if(null != obj.sticky)
	{
		obj.buttondown = (true == obj.buttondown);

		// Menu drop down buttton.
		if (null != obj.submenu )
		{
			f_CbMenuShow( obj.buttondown ? null : obj );
			return(false);
		}

		if(false == obj.buttondown)	// Button is not currently down.
		{
			obj.className="tbButtonDown";
			obj.buttondown = true;

			var szToggles = (null != obj.stickytoggle) ? obj.stickytoggle : obj.radio;
			if(null != szToggles)
			{   
				var x;
				var rg_szItems = szToggles.split(";");
				for( x=0;x<rg_szItems.length;x++ )
				{
					var tempobj = AccessFld(g_WinDocAll[rg_szItems[x]]);
					tempobj.className = "tbButton";
					tempobj.buttondown = false;
				}
			}
		}
									// Button is down & is not a radio button..
		else if(true == obj.buttondown && (null == obj.radio))
		{
			obj.className = "tbButton";
			obj.buttondown = false;  
			f_CbMenuShow( null );  
		}

		if( true != fNoEvent )
		{
			onCbClick(obj.id, obj.buttondown);
		}
		return(false);
	}

	// Regular push button
	if(null != obj.swapitems )
	{
		var x;
		var rg_szItems = obj.swapitems.split(";");
		for( x=0; x < rg_szItems.length; x++ )
		{
			with(g_WinDocAll[rg_szItems[x]].style)
			{
				display = ("none" == display) ? "" : "none";
			}
		}
	}
	f_CbMenuShow( null );
	onCbClick(obj.id, true);

	return(false);
}
function f_CbMenuShow( obj )
{
	var szClass = "tbButtonRaise";

	if( null != obj )	// Show the submenu of the current item.
	{
		obj.className="tbButtonDown";
		obj.buttondown = true;

		var oMenu = AccessFld(g_WinDocAll[obj.submenu]);
		var objStyle = oMenu.style;
		objStyle.display = "";
		objStyle.posLeft = event.clientX - event.offsetX - obj.offsetLeft - 5;
		objStyle.posTop = event.clientY - event.offsetY - obj.offsetTop + obj.offsetHeight - 3;
		g_WinDoc.onmouseup = onDocumentMouseDown;
		g_WinDoc.onmouseout = onDocumentMouseOut;
		f_CbMenuShow.current = obj;
	}
	else				// Hide any menu
	{
		if( null == f_CbMenuShow.current )
		{
			return;
		}

		obj = f_CbMenuShow.current;
		f_CbMenuShow.current = null;
		if(null == obj.submenu)
		{
			return;
		}

		obj.className = "tbButton";
		obj.buttondown = false;
		var oMenu = AccessFld(g_WinDocAll[obj.submenu]);
		szClass = "tbButton";
		oMenu.style.display = "none";
		oMenu.onmouseout=null;
		g_WinDoc.onmouseup = null;
		g_WinDoc.onmouseout = null;
	}

	// Raise or lower any associated buttons with the menu.
	if(null != obj.overelements)
	{
		var tempObj = AccessFld(g_WinDocAll[obj.overelements]);
		if( null != tempObj && true != tempObj.buttondown )
		{
			tempObj.raised = (szClass == "tbButtonRaise");
			tempObj.className=szClass;
		}           
	}
}
f_CbMenuShow.current = null;
