//Copyright (c) 2000-2001 Microsoft Corporation.  All rights reserved.
//<script>

var g_winDocAll = window.document.all;
var g_iAddCount=0;
var g_iTabTopOffset = 38;
var g_fHasGottenFolders = false;
var g_rgAuthDomains = new Array();
var g_nFlybarHeight = 25;
var g_idFlyPopup = -1;
var g_nFontHeight=13;
var CTL_E_PERMISSIONDENIED = (1^0x800a0046)-1;
var FACILITY_WIN32_ERROR_ACCESS_DENIED = (1^0x80070005)+1;
var g_wndReminder = null;
var g_ctlReminder = null;
var g_nEnableNewMail = 0;
var g_fUnix = false;

/*******Init Error String************/
g_szrgErrors = new Array();
g_szrgErrors[900]   = L_errCommunicationfailure_ErrorMessage;
g_szrgErrors[401]   = L_errLogonFailure_ErrorMessage;
g_szrgErrors[404]   = L_ErrorItemNotFound_ErrorMessage;
g_szrgErrors[405]   = L_idsFolderDuplicateNameError;
g_szrgErrors[403]   = L_errAccessDenied_ErrorMessage;
g_szrgErrors[412]   = L_errPreconditionfailure_ErrorMessage;
g_szrgErrors[500]   = L_errInternalServerError_ErrorMessage;
g_szrgErrors[501]   = L_errInternalServerError_ErrorMessage;
g_szrgErrors[502]   = L_errBadGateway_ErrorMessage;  //DAV return Bad Gateway.
// This error occurs when copying folders between private and public stores
g_szrgErrors[503] = L_errServiceNotAvailable_ErrorMessage;
g_szrgErrors[1001] = L_ErrorIllegalCharacter_Text;
var g_ctlNotify = null;
var g_oSound = null;
var g_oPopup = null;

function objTree_OnFolderOperationComplete()
{
	if(event != null && event.contentType == 1)
	{
		try
		{
			parent.viewer.RefreshMessageList(null); // force refresh
		}
		catch(e) { 	}
	}
}
function objTree_onError()
{
	f_HandleError(event.statusCode)
}

function objTree_onReady()
{
	g_iAddCount = 2;
	if (g_fPublicOnly)
	{
		if (g_fPublicTierOn)
		{
			if (g_fPublicRoot)
				objTree.addHierarchy(window.location, true, g_szPublicFoldersDN);
			else
				objTree.addHierarchy(window.location, true, null);
		}
	}
	else
	{
		objTree.addHierarchy(g_szUserBase, true, g_szUserDisplayName);
		var szPublicFolderUrl = g_szPublicFolderUrl;

		if (g_fPublicTierOn)
		{
			if (g_szPublicFolderUrl == "")
			{
				// We are going through a front-end so go after /public
				// off the front-end host
				szPublicFolderUrl = window.location.protocol + "//" + window.location.host + "/public/";
			}
			objTree.addHierarchy(szPublicFolderUrl, false, g_szPublicFoldersDN);
		}
	}
	treeProgress.style.display = "none"
	g_winDocAll['objTree'].style.height = "100%";
}

function objTree_onSelectFolder()
{
	event.cancelBubble  = true;
	event.returnValue   = false;

	if(event)
	{
		if(event.isContext == true)
		{
			var node = objTree.selectedNode;
		}
		else
		{
			Navigate(event.url + "?Cmd=contents"+((event.isDeletedItems)?"&allowShowDeleted=1":"") );
		}
	}
}
function window.document.oncontextmenu()
{
	if(null != event.returnValue)
	{
		if("object" == typeof(event.returnValue))
		{
			idTreeMenu.menuShow(true,event.clientX, event.clientY+15);
		}
	}
}

function ToggleTab(srcElementID)
{
	event.cancelBubble = true;
	event.returnValue = false;

	if (!g_fPublicOnly)
	{
		var tempEl;
		var srcEl = g_winDocAll[srcElementID];

		if(srcEl.id == "show_folders")
		{
			if(g_iAddCount == 0)
			{
				g_iAddCount++;

				treeProgress.style.display = "";
				g_nFontHeight = g_winDocAll.idLoading.offsetHeight;
				objTree.addBehavior(g_szVirtualRoot + "/CONTROLS/ctrl_Tree20.htc");
			}

			g_winDocAll['idOutbarpane'].parentElement.style.display="none";
			g_winDocAll['objTree'].style.display="";
			setDefaultView("1");
		}
		if(srcEl.id == "show_navbar")
		{
			g_winDocAll['objTree'].style.display="none";
			g_winDocAll['idOutbarpane'].parentElement.style.display="";
			setDefaultView("0");
		}
	}
}

function DepressTab(objButton)
{
	g_winDocAll['btnShowFolders'].style.borderStyle =
	g_winDocAll['btnShowNavbar'].style.borderStyle = "outset";

	objButton.style.borderStyle = "inset";
}

function window.onload()
{
	if(!g_szUserBase)
	{
		return(false);
	}

	var oStyleSheet = window.document.styleSheets("idNavbarStyle");
	var szFont = "font-family:'" + window.document.body.currentStyle.fontFamily + "'";
	oStyleSheet.addRule( ".buttonNormal", szFont );

	if (g_fPublicOnly)
	{
		treeProgress.style.display = "";
		g_nFontHeight = g_winDocAll.idLoading.offsetHeight;


		objTree.addBehavior(g_szVirtualRoot + "/controls/ctrl_Tree20.htc")
		g_winDocAll['idOutbarpane'].parentElement.style.display="none";
		g_winDocAll["btnShowNavbar"].disabled = true;
		g_winDocAll['objTree'].style.display="";
	}
	else
	{
		re = /Win[0-9]+|WinCE/i;
		g_fUnix = !re.test( window.navigator.platform );
		if( "0" != g_szEnableReminders )
		{
			g_ctlReminder = g_winDocAll['objReminder'];
			if( null != g_ctlReminder )
			{
				g_ctlReminder.onchange = onReminders;
				g_ctlReminder.enable = true;
			}
		}
		g_nEnableNewMail = parseInt( g_szEnableNewMail, 10 );
		if( 0 != g_nEnableNewMail )
		{
			g_ctlNotify = g_winDocAll['objNotify'];
			if( null != g_ctlNotify )
			{
				g_ctlNotify.onchange = onNewMail;
				g_ctlNotify.enable = true;

				try
				{
					g_oPopup = window.createPopup();
				}
				catch(e)
				{
				}
			}
		}
		if ("1" == g_bShowFolders)
		{
			g_winDocAll["btnShowFolders"].click();
		}
		else
		{
			g_winDocAll["btnShowNavbar"].click();
		}
	}
}

function Navigate(url)
{
	if(parent != null && url != null)
	{
		if(parent.viewer != null)
		{
			parent.viewer.location = url;
		}
	}
}

function slide_Tabs()
{
	ToggleTab(event.srcElement.parentElement.id);
}

function DoRenameCommand()
{
	var objFolder = objTree.selectedNode;
	var szName = objFolder.displayname;
	var szURL = objFolder.url;

	var szNewName   =   prompt(L_RenameCurrentFolder_Text, szName);

	if(szNewName != null)
	{
		if (szNewName.length > 255)
			szNewName = szNewName.slice(0, 255);

		objTree.renameFolder(szURL, szNewName);
	}
}

function DoMoveCopyCommand(mode)
{
	var szDialog = g_szUserBase+"?Cmd=dialog&template=dlg_movecopy"
	var szNewFolderDialog = g_szUserBase +"?Cmd=dialog&template=dlg_newfolder"
	var rgParams = new Array();
	rgParams["g_OpenerTreeCtrl"] = objTree;
	rgParams["g_CurrentFolderNode"] = objTree.selectedNode;
	rgParams["g_Location"] = g_szUserBase;
	rgParams["g_VirtualRoot"] = g_szVirtualRoot;
	rgParams["g_NewFolderDialogPath"] = szNewFolderDialog;
	rgParams["g_MoveCopyMode"] = mode;

	var oStyle = g_winDocAll.idLoading.currentStyle;
	var nFontHeight = g_nFontHeight - 3;
	var szFont = "FONT:"+ oStyle.fontFamily + ";font-size:" + nFontHeight + ";";
	var nWidth = 50 + 25 * nFontHeight;
	var nHeight = 200 + 12 * nFontHeight;
	var hWin = window.showModalDialog(szDialog, rgParams, szFont+"dialogHeight:"+nHeight+"px;dialogWidth:"+nWidth+"px;status:no;resizable:yes;help:no;")
}

function DoNewFolderCommand()
{
	//Verify that user has access to folder

	if(!f_Authenticate(objTree.selectedNode.url))
	{
		return(false)
	}

	var szNewFolderDialog           =   g_szUserBase +"?Cmd=dialog&template=dlg_newfolder"
	var rgParams                    =   new Array();
	rgParams["g_OpenerTreeCtrl"]    =   objTree;
	rgParams["g_CurrentFolderNode"] =   objTree.selectedNode;
	rgParams["g_Location"]          =   g_szUserBase;
	rgParams["g_VirtualRoot"]       =   g_szVirtualRoot;

	var oStyle = g_winDocAll.idLoading.currentStyle;
	var nFontHeight = g_nFontHeight - 3;
	var szFont = "FONT:"+ oStyle.fontFamily + ";font-size:" + nFontHeight + "px;";
	var nWidth = 50 + 25 * nFontHeight;
	var nHeight = 220 + 12 * nFontHeight;
	var hWin = window.showModalDialog(szNewFolderDialog, rgParams, szFont+"dialogHeight:"+nHeight+"px;dialogWidth:"+nWidth+"px;status:no;resizable:yes;help:no;")
}

function f_Authenticate(szURL)
{
	var szServerName = f_getServerName(szURL);
	var iStatus = 0;
	var bretval = true;
	var szDocumentDomain = window.document.domain
	if(szDocumentDomain.toLowerCase() != szServerName.toLowerCase())
	{
		//Check the cache to see if already authenticated
		if(null == g_rgAuthDomains[szServerName])
		{
			/*** Send an options to the server to cause authentication to the new domain */
			var objXMLHTTP = new ActiveXObject("Microsoft.XMLHTTP");
			objXMLHTTP.open( "OPTIONS", szURL,false);
			objXMLHTTP.send();

			if(200 != objXMLHTTP.status)
			{

				f_HandleError(iStatus);
				bretval = false;
			}
			else
			{
				//Set empty string to server name.  We only use this array as a look up.

				g_rgAuthDomains[szServerName] = "";
				bretval = true;
			}
		}
		else
		{
			bretval = true;
		}
	}
	return(bretval)
}

function f_getServerName(szURL)
{
	f_getServerName.re.lastIndex=0;
	var rgVals = f_getServerName.re.exec(szURL)
	return(rgVals[1])
}
f_getServerName.re =  new RegExp("^https?://([^/]+)","i")

function f_HandleError(num)
{
	if(g_szrgErrors[num])
	{
		alert(g_szrgErrors[num]);
	}
	else if(num == CTL_E_PERMISSIONDENIED || num == FACILITY_WIN32_ERROR_ACCESS_DENIED)
	{
		alert(L_errCrossDomainAccessDenied_ErrorMessage)
	}
	else
	{
		alert(L_idsUnknownError_Text + "\r\n" + num);
	}

}

function MenuSelect(item)
{
	switch (item)
	{
		case "Delete":
			var node    =   objTree.selectedNode;
			var szName  =   node.displayname;
			var szURL   =   node.url;
			if(confirm(L_ConfirmDelete_Text))
			{
				objTree.deleteFolder(szURL);
			}
		break;
		case "Rename":
			DoRenameCommand();
		break;
		case "Copy":
			DoMoveCopyCommand("Copy");
		break;
		case "Move":
			DoMoveCopyCommand("Move");
		break;
		case "New Folder":
			DoNewFolderCommand();
		break;
		case "Refresh":
			var objFolder = objTree.selectedNode
			if(null != objFolder)
			{
				objTree.refreshFolder(objFolder.url);
			}
		break;
		case "Open":
			var node = objTree.selectedNode;
			if(node)
			{
				Navigate(node.url + "?Cmd=contents" +((node.isDeletedItems)?"&allowShowDeleted=1":"") );
			}
		break;
		case "OpenNewWindow":
			var node        = objTree.selectedNode;
			var szURL       = node.url + "?Cmd=contents" +((node.isDeletedItems)?"&allowShowDeleted=1":"");
			var windowName  = new String(Math.round(Math.random() * 100000));
			var hWin = window.open(szURL,windowName,"toolbar=1,location=1,directories=1,status=1,menubar=1,scrollbars=1,resizable=1")
		break;
	}
	return (false);
}

var m_szReminders;

function ShowReminders(szXml)
{
	var i = 0;
	var fRc = false;
	try
	{
		if( (null != g_wndReminder) && (!g_wndReminder.closed) )
		{
			var x = g_wndReminder.dialogLeft;
			if( 0 > window.screenLeft )
			{
				g_wndReminder.close();
				g_wndReminder=null;
			}
			else
			{
				g_wndReminder.updateData(szXml);
				fRc = true;
			}
		}
		if( true === fRc )
		{
			return;
		}
	}
	catch(e)
	{
		g_wndReminder=null;
	}

	var rgParams= new Array();
	rgParams["xmlData"] = szXml;
	rgParams["callback"] = onSnooze;
	rgParams["Sound"] = ("2" === g_szEnableReminders);
	rgParams["WavFile"] = g_szReminderWav;
	rgParams["Snooze"] = Snooze;
	rgParams["Dismiss"] = Dismiss;

	var obj = g_winDocAll("show_navbar").firstChild;
	var nFontHeight = obj.firstChild.offsetHeight - 4;
	var oStyle = obj.currentStyle;
	var szFont = "FONT:"+ oStyle.fontFamily + ";font-size:" + nFontHeight + ";";
	var nWidth = 110 + 35 * nFontHeight;
	var nHeight = 120 + 16 * nFontHeight;
	g_wndReminder = window.showModelessDialog(g_szUserBase+"?Cmd=dialog&template=dlg_reminders", rgParams,szFont+"dialogHeight:"+nHeight+"px;dialogWidth:"+nWidth+"px;status:no;resizable:yes;help:no;");

}

function UpdateReminder()
{
	ShowReminders( m_szReminders );
}

function closeReminder()
{
	if( g_wndReminder && (!g_wndReminder.closed) )
	{
		try
		{
			g_wndReminder.close();
		}
		catch(e)
		{
		}
	}
	g_wndReminder = null;
}

// When new data is available from reminder polling control.
function onReminders()
{
	var i = event.count;
	m_szReminders = event.szXml;
	if( 0 == i )
	{
		closeReminder();
	}
	else
	{
		window.setTimeout( UpdateReminder, 100 );
	}
}

// Called when item is dismissed from reminder dialog.
function onSnooze()
{
	window.setTimeout( cb_onSnooze, 100 );
}

function cb_onSnooze()
{
	if( g_ctlReminder )
	{
		g_ctlReminder.poll();
	}
}

function Snooze( rgItems, iMinutes)
{
	var re = /\/[^/]*$/;
	var szProp;

	if( 0 > iMinutes )
	{
		var dtReminder = new Date();
		dtReminder.setMinutes( dtReminder.getMinutes() + -iMinutes );

		iMinutes = toISOTimeString(dtReminder);
		szProp = 'remindernexttime';
	}
	else
	{
		iMinutes = iMinutes * 60;
		szProp = 'reminderoffset';
	}

	var fRc = true;
	while( rgItems.length )
	{
		var rgTodo = new Array();
		var szURL = rgItems[0].apptURL.replace( re, "" );

		var xml = '<?xml version="1.0"?\><a:propertyupdate xmlns:a="DAV:"><a:set><a:prop>' +
				  '<d:' + szProp + ' xmlns:d="urn:schemas:calendar:">'+ iMinutes + '</d:' + szProp + '>' +
				  '</a:prop></a:set><a:target>';
		var j = 0;
		var i;
		for( i = 0; i < rgItems.length; i++ )
		{
			var szTemp = rgItems[i].apptURL.replace( re, "" );
			if( szTemp === szURL )
			{
				xml+= '<a:href>'+rgItems[i].apptURL + '</a:href>';
			}
			else
			{
				rgTodo[j++] = rgItems[i];
			}
		}
		xml += '</a:target></a:propertyupdate>';

		fRc = batchModify( szURL, xml );
		if( !fRc )
		{
			break;
		}
		rgItems = rgTodo;
	}
	return fRc;
}

function Dismiss(rgItems)
{
	var re = /\/[^/]*$/;

	var fRc = true;
	while( rgItems.length )
	{
		var rgTodo = new Array();
		var szURL = rgItems[0].apptURL.replace( re, "" );

		var xml = '<?xml version="1.0"?\><a:propertyupdate xmlns:a="DAV:"><a:set><a:prop>' +
				  '<d:remindernexttime xmlns:d="urn:schemas:calendar:">4501-01-01T00:00:00.000Z</d:remindernexttime>' +
				  '</a:prop></a:set><a:target>';
		var j = 0;
		var i;
		for( i = 0; i < rgItems.length; i++ )
		{
			var szTemp = rgItems[i].apptURL.replace( re, "" );
			if( szTemp === szURL )
			{
				xml+= '<a:href>'+rgItems[i].apptURL + '</a:href>';
			}
			else
			{
				rgTodo[j++] = rgItems[i];
			}
		}
		xml += '</a:target></a:propertyupdate>';

		fRc = batchModify( szURL, xml );
		if( !fRc )
		{
			break;
		}

		xml = '<?xml version="1.0"?\><a:propertyupdate xmlns:a="DAV:"><a:remove><a:prop>' +
			  '<d:reminderoffset xmlns:d="urn:schemas:calendar:" />' +
			  '</a:prop></a:remove><a:target>';
		j = 0;
		for( i = 0; i < rgItems.length; i++ )
		{
			var szTemp = rgItems[i].apptURL.replace( re, "" );
			if( szTemp === szURL && "0" === rgItems[i].type )
			{
				xml+= '<a:href>'+rgItems[i].apptURL + '</a:href>';
				j++;
			}
		}
		if( 0 < j )
		{
			xml += '</a:target></a:propertyupdate>';
			fRc = batchModify( szURL, xml );
		}
		if( !fRc )
		{
			break;
		}
		rgItems = rgTodo;
	}
	return( fRc );
}

function batchModify( szURL, szXML )
{
	var fSuccess = false;
	try
	{
		var Req = new ActiveXObject("Microsoft.XMLHTTP");
		Req.open("BPROPPATCH", szURL, false);
		Req.setRequestHeader("Content-Type","text/xml");
		Req.setRequestHeader("Translate","f");
		Req.setRequestHeader("Brief","t" );

		Req.send(szXML);
		fSuccess = true;
	}
	catch(e)
	{
	}

	if( fSuccess && ((200 > Req.status) || (300 <= Req.status)) )
	{
		// if the error was not "Item not found"
		if( 404 != Req.status )
		{
			fSuccess = false;
		}
	}
	return fSuccess;
}

function toISOTimeString(dtDate)
{
	var sTime = dtDate.getUTCFullYear() + "-00-00T00:00:00Z";

	var i = dtDate.getUTCMonth()+1;
	sTime = sTime.substr(0,(10 > i) ? 6 : 5) + i + sTime.substr(7);

	i = dtDate.getUTCDate();
	sTime = sTime.substr(0,(10 > i) ? 9 : 8) + i + sTime.substr(10);

	i = dtDate.getUTCHours();
	sTime = sTime.substr(0,(10 > i) ? 12 : 11) + i + sTime.substr(13);

	i = dtDate.getUTCMinutes();
	sTime = sTime.substr(0,(10 > i) ? 15 : 14) + i + sTime.substr(16);
	return sTime;
}

// When new mail is detected in the inbox.
function onNewMail()
{
	if( 2 <= g_nEnableNewMail )
	{
		PlaySound();
	}
	if( 0 == (1 & g_nEnableNewMail) )
	{
		return;
	}

	var obj = g_winDocAll['idNewMail'];
	if( null != obj )
	{
		obj.style.display="";
		for( var i = 0; i < 3; i++ )
		{
			var n = obj.scrollHeight - obj.clientHeight;
			if( 0 < n )
			{
				obj.style.height = (i+4)+"em";
			}
			else
			{
				break;
			}
		}
	}
    AnimateNotify();
	if( 1 < g_iAddCount )
	{
		objTree.updateFolderCount( g_ctlNotify.folder+"/" );
	}
}

function PlaySound()
{
	if( null == g_oSound )
	{
		if( !g_fUnix )
		{
			g_oSound = window.document.all['idSound'];
		}
		else
		{
			var oSnd = document.createElement("BGSOUND");
			oSnd.id = "idSound";
			oSnd.src = g_szNewMailWav;
			oSnd.LOOP=1;
			g_oSound = document.body.insertBefore( oSnd, null );
		}
	}
	if( null != g_oSound )
	{
		if( !g_fUnix )
		{
			g_oSound.beginElement();
		}
		else
		{
			g_oSound.src = g_oSound.src;
		}
	}
}

function flyInit()
{
	flyMove.expand = 0;
	flyMove.flyY = window.screen.height;
	flyMove.flyX = window.screen.width;
}

function flyMove()
{
	flyMove.expand += 2;
	flyMove.flyY -= 2;
	g_oPopup.show(flyMove.flyX-flyMove.expand, flyMove.flyY, flyMove.expand, flyMove.expand);
	var oPopupBody = g_oPopup.document.body;
	if (oPopupBody.clientWidth >= oPopupBody.scrollWidth && oPopupBody.clientHeight >= oPopupBody.scrollHeight)
	{
		window.clearInterval(g_idFlyPopup);
		g_idFlyPopup = -1;
		window.setTimeout( 'closePopup()', 15000 );
	}
}
flyMove.expand = 0;
flyMove.flyY = 0;
flyMove.flyX = 0;

function AnimateNotify()
{
	if( null == g_oPopup )
	{
		return;
	}
	var oPopupBody = g_oPopup.document.body;

	var obj = g_winDocAll['idNewMail'].firstChild;
	var szHTML = "<TABLE height=100% width=100% cellpadding=5 cellspacing=5 style=\"FONT-SIZE:smaller\"><TR><TD align=middle >"+
				 "<A HREF=\"#\" HIDEFOCUS>"+obj.title+"</A><BR><IMG id='nbImage' style='padding-top:4px;CURSOR:hand;BORDER:0 none;' src='' alt=''><DIV></DIV>"+
				 "</TD></TR></TABLE>"

	oPopupBody.innerHTML = szHTML;
	var obj = g_winDocAll['inbox'];
	if( null != obj )
	{
		obj = obj.firstChild;
		var oImg = oPopupBody.all['nbImage'];
		oImg.alt = obj.alt;
		oImg.src = obj.src;
		obj = obj.parentElement.nextSibling;
		oImg.nextSibling.innerText = obj.innerText;
	}
	oPopupBody.style.fontSize = document.body.currentStyle.fontSize;
	oPopupBody.style.backgroundColor='infobackground';
	oPopupBody.style.cursor="hand";
	oPopupBody.style.color = "infotext";
	oPopupBody.style.borderWidth='3px';
	oPopupBody.style.borderStyle='window-inset';
	oPopupBody.style.borderColor='activeborder';
	oPopupBody.onclick = ShowInbox;
	flyInit();
	g_idFlyPopup = window.setInterval(flyMove,10);
}

function closePopup()
{
	if( null != g_oPopup )
	{
		g_oPopup.hide();
	}
}

function ShowInbox()
{
	window.top.focus();
	Navigate( g_ctlNotify.folder + "/?Cmd=contents" );
	if( -1 != g_idFlyPopup )
	{
		window.clearInterval(g_idFlyPopup);
		g_idFlyPopup = -1
	}
	closePopup();
	var obj = g_winDocAll['idNewMail'];
	if( null != obj )
	{
		obj.style.display="none";
	}
}

function newOptions( szVal )
{
	var rgVals = szVal.split(',');
	if( g_szEnableReminders != rgVals[0] )
	{
		g_szEnableReminders = rgVals[0];
		switch( g_szEnableReminders )
		{
			default:
			case "0":
				if( g_ctlReminder )
				{
					g_ctlReminder.enable=false;
				}
				closeReminder();
				break;
			case "1":
			case "2":
				closeReminder();
				g_ctlReminder = g_winDocAll['objReminder'];
				if( null != g_ctlReminder )
				{
					g_ctlReminder.onchange = onReminders;
					g_ctlReminder.enable = true;
				}
				break;
		}
	}

	if( g_szEnableNewMail != rgVals[1] )
	{
		g_ctlNotify = g_winDocAll['objNotify'];
		if( null == g_ctlNotify )
		{
			return;
		}
		if( "0" == rgVals[1] )
		{
			g_ctlNotify.enable = false;
		}
		else
		{
			if( 0 == g_nEnableNewMail )
			{
				g_ctlNotify.enable = true;
				g_ctlNotify.onchange = onNewMail;
			}
		}
		g_szEnableNewMail = rgVals[1];
		g_nEnableNewMail = parseInt( g_szEnableNewMail, 10 );
	}
}

function onopened( szFolder )
{
	var szInbox = "";
	if( g_szInboxFolder.length )
	{
		szInbox = g_szInboxFolder.substr(1);
		if( szFolder === szInbox )
		{
			closePopup();
			var obj = g_winDocAll['idNewMail'];
			if( null != obj )
			{
				obj.style.display="none";
			}
		}
	}
	return szInbox;
}

function setDefaultView(sValue)
{
	if (g_bShowFolders == sValue)
	{
		return;
	}
	g_bShowFolders = sValue;

	var szXML = "<?xml version=\"1.0\" ?>" +
				"<D:propertyupdate xmlns:D=\"DAV:\" xmlns:a=\"http://schemas.microsoft.com/exchange/\">" +
					"<D:set><D:prop><a:webclientshowhierarchy>" + sValue + "</a:webclientshowhierarchy></D:prop></D:set>" +
				"</D:propertyupdate>";
	var objXMLHttpRequest= new ActiveXObject("Microsoft.XMLHTTP");
	objXMLHttpRequest.open("PROPPATCH", g_szUserBase, true);
	objXMLHttpRequest.setRequestHeader("Content-Type","text/xml");
	objXMLHttpRequest.setRequestHeader("Depth", "0");

	objXMLHttpRequest.send(szXML);
}
