<?php
/**
 * /public_html/challenges/encryption/enc_extra.php
 *
 * Difficult encryption challenge with cash reward
 *
 * @author    Ahmed Chafik
 * @copyright Achafik 2005
 * @version   Define("Id: enc_extra.php,v 1 2005/11/12 22:03:48 Ahmed")
 *
 * --------------------------------------------------
 *
 * Flag  Date        By     Action / Reason
 * $L1   1131896567  Jake   Added authorization to script - makes client login to
 *                          HBH :: Better tracking and helps make sure users arn't
 *                          cheating
 *
 */
 @require_once "../../fusion_config.php";
  require_once "../../fusion_core.php";

 $cfg['global']['alpha']       = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_-';
 $cfg['global']['enc_script']  = "http://urbnites.com/encryptx2902.php"; //"http://216.86.156.205/~achafikc/encryptx2902.php";
 $cfg['global']['credentials'] = authorize_user();

 if ( !preg_match('/firefox/', strtolower($_SERVER['HTTP_USER_AGENT'])) ) {
     die(
         "We could not confirm that you are using a Firefox browser, please open"
        ." the script using firefox or reset your useragent string.<br/>"
        ."<a href=\"http://www.mozilla.org/products/firefox/\">Download Firefox!</a>"
        );

 }

 function code( $string ) {
   global $cfg, $is_authed;

     // Format the alphabet for Regex
     $Regex['alpha'] = '('.str_replace(chr(2), "|", preg_quote(preg_replace("/(.+?)/", "\\1".chr(2), $cfg['global']['alpha']), '\\')).'a)';

     if ( !preg_match("/^{$Regex['alpha']}+$/", $string) ) {
         return "INVALID:The string you entered contains invalid characters";
     } elseif ( strlen($string) > 20 ) {
         return "INVALID:The string may not be longer than 20 characters";
     } elseif ( strlen($string) == 17 ) {
         return "INVALID:The string may not be 17 characters, this is to prevent brute force attempts";
     } else {
         if (   !(@$result = file($cfg['global']['enc_script']."?ip={$cfg['global']['credentials']['ID']}|{$cfg['global']['credentials']['NAME']}|{$_SERVER['REMOTE_ADDR']}&stringHiddenx909z=$string"))   )
             return "INVALID:Couldn't connect to encryption server, please contact Jake!";

       $result = is_array($result) ? $result : array($result);
       $result = implode('', $result);

       return $result;
     }
 }

 function authorize_user () {
   global $userdata;

     if ( isset($userdata) and isset($userdata['user_id']) and $userdata['user_id'] > 0 ) {
       return array('ID' => $userdata['user_id'], 'NAME' => urlencode($userdata['user_name']));
     }

   return FALSE;
 }

 $string = '';
 if ( $_SERVER['REQUEST_METHOD'] == 'POST' and isset($_POST['string']) and is_string($_POST['string']) ) {
     $string = code($_POST['string']);

     $Regex['alpha'] = '('.str_replace(chr(2), "|", preg_quote(preg_replace("/(.+?)/", "\\1".chr(2), $cfg['global']['alpha']), '\\')).'a)';

     $value = '';
     for ( $i = 0; $i < strlen($_POST['string']); $i++ ) {
         $value .= preg_match("/^{$Regex['alpha']}$/", $_POST['string'][$i]) ? $_POST['string'][$i] : '';
     }

 } else $value = 'test';

 if ( isset($_GET['image']) ) {

     switch ( $_GET['image'] ) {
         case 'arrow':
             $image = 'R0lGODlhCwALAKIAAP///8zMzJmZmWZmZv///wAAAAAAAAAAACH5BAUUAAQALAAAAAALAAsAAAMkSCTcogvICUakdIic9xzD54GkpGUhEJzftHpYsBKpJM8KqSsJADs=';
             break;

         case 'button':
             $image = 'R0lGODlhAgAUANUAAGKFp5O22VN3mk1xklh7nU9zlmSHq1d5m0tukGaIrGCCpmmMr2+RtIqt0Ft9n4apzFByk4WozFx/oV6BomqMr26RtJO22lN1l4mt0Eptj4Gkx5W53Hibvnygw5C013OWuY2w0wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAACABQAAAYlwM0mYPF4QCBMI/LQaDodDufzYVQoi4QBoJhIHISD4FKADBCZIAA7';
             break;
     }

     if ( isset($image) ) {
         header('Content-Type: image/jpeg');
         die(base64_decode($image));
     } else die("Image not found");
 }

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html style="margin-top: 0px; margin-left: 5px; margin-right: 5px;" z="">
<head>
    <title>HBH Extra Encryption Challenge</title>
    <meta http-equiv="title" content="HBH Extra Encryption Challenge">
    <meta name="resource-type" content="text/html; charset=iso-8859-1">
    <meta name="content-type" content="text/html; charset=iso-8859-1">
    <meta name="revisit-after" content="14 days">
    <meta name="classification" content="Web Master Resources">
    <meta name="description" content="Encryption Challenge for HBH">
    <meta name="keywords" con
    tent="php, Develop, accelerate, Web development, Apache, scripting languages, e-commerce, freelancing, mySQL, code, programming, business, technology, HTML, PHP5">
    <meta name="robots" content="FOLLOW">
    <meta name="distribution" content="Global">
    <meta name="rating" content="General">
    <meta http-equiv="reply-to" content="o0jake0o@gmail.com">
    <meta http-equiv="Pragma" content="no-cache">
    <style type="text/css">
        * {
            margin:0;
            padding:0;
        }
        body {
            background : #A9BAC3;
            padding-top: 20px;
            color:#66737B;
            font-size: x-small;
            font-family: Verdana, Arial, Helvetica, sans-serif;
            margin-left:auto;
            margin-right:auto;
            width: 752px;
            text-align:left;
        }
        .fullcol {
            clear: both;
            background: #fff;
            width: 726px;
            border: 1px solid #FFF;
            padding: 0 12px 20px;
        }
        .heading {
            height: 20px;
            margin: 5px 0;
            background: #EEF0F1;
            border: 1px solid #DDE1E3;
        }
        .heading h1 {
            font-weight: bold;
            font-size: 10px;
            padding: 3px 15px 3px 20px;
            border: 1px solid #FFF;
        }
        li {
            padding:0 0 0 2.1em;
            margin: 0 0 0.5em;
            list-style: none;
            font-size: 11px;
        }
        li a {
            color: #6699CC;
        }
        li a:hover {
            color: #99CA3C;
        }
        .list li {
            list-style: url(<?= basename(__FILE__) ?>?image=arrow) inside;
        }
        b {
            color:#92979C;
            padding:0 0 0 15px;
            margin: 0;
            padding-bottom: 0;
            font-size: 11px;
            line-height: 14px;
        }
        td {
            padding: 5px;
            margin: 0;
            margin-bottom: 15px;
            border: 1px solid #EEF0F1;
            font-size: 11px;

        }
        input.submit {
            font-family: Geneva, Arial, Helvetica, sans-serif;
            color: #FFFFFF;
            background-attachment: scroll;
            background-color: #57799B;
            background-image: url(<?= basename(__FILE__) ?>?image=button);
            background-repeat: repeat;
            background-position: 0px 0px;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <center>
    <div class="fullcol">
        <div class="heading"><h1>HBH Encryption Challenge</h1></div>
        <table>
<?
 if ( !is_array($cfg['global']['credentials']) ) {
 ?>
            <tr>
                <td width="60%" colspan="2" align="center">
                        You must be logged in to HBH
                </td>
            </tr>
            <form method="post">
            <tr>
                <td>Username:</td>
                <td><input type="text" name="user_name" maxlength="20" /></td>
            </tr>
            <tr>
                <td>Password:</td>
                <td><input type="password" name="user_pass" maxlength="20" /></td>
            </tr>
            <tr>
                <td colspan="2" align="center">
                    <input type="submit" class="submit" value="Login and try this challenge!" />
                    <input type="hidden" name="login" value="Login" />
                    <input type="hidden" name="goto" value="encrypt" />
                </td>
            </tr>
            </form>
 <?
 exit;
 }

 $users_attempted = @file($cfg['global']['enc_script'].'?members=TRUE');
 if( !is_array($users_attempted) )
     die('Sorry, but we are currently experiencing some technical difficulties, please try again shortly.');

 $users_attempted = preg_replace('/^\-(.*?)\-$/', '\\1', $users_attempted[0]);

?>
            <tr>
                <td width="58%" rowspan="2">
                    <b>Description</b><br/>
                    <li>
                        Decrypt this string: <span style="color: #ff0000">qrIRi1Lfu8O5nKuGh</span>
                    </li>
                    <br/>

                    <b>Rules</b><br/>
                    <ol class="list">
                        <li style="margin-bottom: 15px;">
                            All materials used to aid in the decryption of the
                            string must be submited along with the answer. This
                            would include scripts, websites, programs, etc. . . .
                        </li>
                        <li>
                            The cash reward offered for this challenge shouldn't
                            be viewed as an incentive to engage in the misuse of
                            computing resources. Anybody suspected of misconduct
                            in this challenge may be void from the reward without
                            notice or reason.
                        </li>
                    </ol>
                    <br/>

                    <b>Prize</b><br/>
                    <li>
                        $150.00 <a target="_blank" href="http://www.xe.com/ucc/">USD</a>
                    </li>
                    <br/>

                    <b>Submissions</b><br/>
                    <li>
                        All submissions must be emailed to o0Jake0o@gmail.com<br/>
                        . . . or you may contact me on the HBH site through PM
                    </li>
                    <br/>

                    <b>Additional Info</b><br/>
                    <li>
                        If you would like to see if your on the right path, contact Ahmedc123 on AIM, and I MAY help you.<br/>
                        To view the source of this page, go <a href="enc_extra_source.php">here</a>
                    </li>
                    <br/>
                </td>
                <td width="42%" height="15" style="font-size:9px">
                    Challenge attempted by <?= $users_attempted ?> users since <?= date('M d, Y', 1141340932) ?>
                </td>
            </tr>
            <tr>
                <td width="42%">
                    <li>
                        <?php
                            if ( $string === '0' ) $string .= ' ';
                            if ( !empty($string) ) {
                                echo preg_match('/^INVALID\:/', $string) ?
                                     "Error:<br/><div style=\"color: #ff0000; padding-left: 8px\">"
                                     .preg_replace('/^INVALID\:/', '', $string)
                                     ."</div><br/>"
                                : "Encrypted string: <font color=\"#ff0000\">$string</font><br/><br/>";
                            }
                        ?>
                        <form method="post">
                        Enter a string to encrypt:<br/>
                        <div style="padding: 2px;">
                            <input type="text" name="string" maxlength="20" value="<?= $value ?>" <?= ($value == 'test' and $_SERVER['REQUEST_METHOD'] != 'POST') ? "onClick=\"if (this.value=='test') { this.value = '' }\"" : '' ?> />
                        </div>
                        <br/>
                    </li>
                    <div align="center">
                        <input type="submit" class="submit" value="Encrypt This String" />
                    </div>
                    </form>
                </td>
            </tr>
        </table>
    </div>
    </center>
</body>
</html>