<?php
/**
 * public_html/articlecomments.php
 *
 * View and post comments for articles
 *
 * @author    HBH Staff
 * @copyright Hellboundhackers 2003-2006
 * @version   Define("Id: articlecomments.php,v 1 2005/12/23 20:41:34 HBH")
 *
 * --------------------------------------------------
 *
 * Flag  Date        By     Action / Reason
 * $L1   12/23/2005  Jake   Cleaning all code and checking for possible exploits
 *
 */
 @require_once('fusion_config.php');
 require_once('fusion_core.php');
 require_once('subheader.php');
 require_once('side_left.php');

 include FUSION_INCLUDES.'comments_include.php';
 include FUSION_INCLUDES.'ratings_include.php';

 if( !isset($rowstart) ) $rowstart = 0;
 settype($rowstart, 'int');
 settype($article_id, 'int');

 $query = "SELECT ta.*, tu.user_id, user_name, COUNT(comment_item_id) as article_comments
             FROM {$fusion_prefix}articles ta
               LEFT JOIN {$fusion_prefix}users tu ON (ta.article_name=tu.user_id)
               LEFT JOIN {$fusion_prefix}comments ON (ta.article_id=comment_item_id and comment_type='A')
           WHERE article_id='$article_id'
             GROUP BY article_id";

 $result = dbquery($query);

 if( dbrows($result) > 0 ) {
     $data = dbarray($result);

     $article = stripinput(stripslashes($data['article_article']));
     $article = explode('<--PAGEBREAK-->', $article);

     $pagecount = sizeof($article);

     $article_subject = $data['article_subject'];

     $article_info = array( 'article_id'       => $data['article_id'],
                            'user_id'          => $data['user_id'],
                            'user_name'        => $data['user_name'],
                            'article_date'     => $data['article_datestamp'],
                            'article_breaks'   => $data['article_breaks'],
                            'article_comments' => $data['article_comments'],
                            'article_reads'    => $data['article_reads'] );

     render_article($article_subject, $article[$rowstart], $article_info);

     if( $pagecount > 1 ) {
         $rows = $pagecount;

         echo "
         <div align='center' style='margin-top:5px;'>
             ".makePageNav($rowstart,1,$rows,3,FUSION_SELF."?article_id=$article_id&page=$nextpage&")."
         </div>";
     }

     showcomments('A', 'articles', 'article_id', $article_id, FUSION_SELF."?article_id=$article_id");
     showratings('A', $article_id, FUSION_SELF."?article_id=$article_id");

     if( isset($_GET['admin']) ) {

         opentable('Ratings');
         $ratings = array( 5 => RATING_120, 4 => RATING_121, 3 => RATING_122, 2 => RATING_123, 1 => RATING_124 );

         $query = mysql_query("SELECT r.rating_datestamp, r.rating_vote, u.user_name
                                 FROM {$fusion_prefix}ratings r
                                   LEFT JOIN {$fusion_prefix}users u ON (r.rating_user=u.user_id)
                                 WHERE r.rating_item_id='$article_id'
                                   ORDER BY r.rating_vote DESC
                              ");

         echo "
         <table>
             <tr>
                 <td>Rating</td>
                 <td>Username</td>
                 <td>Time</td>
             </tr>
             ";
         while( $row = mysql_fetch_assoc($query) ) {
             echo "
             <tr>
                 <td>".$ratings[$row['rating_vote']]."</td>
                 <td>{$row['user_name']}</td>
                 <td>".date('m d Y - h:i:sa', $row['rating_datestamp'])."</td>
             </tr>";
         }
         echo "</table>";

         closetable();

     }
     // Delete multiple ratings before patch was made
     elseif( isset($_GET['admin2']) ) {

         opentable('Ratings');
         $ratings = array( 5 => RATING_120, 4 => RATING_121, 3 => RATING_122, 2 => RATING_123, 1 => RATING_124 );

         $query = mysql_query("SELECT r.rating_item_id, r.rating_vote as vote, r.rating_id,
                                      u.user_name, u.user_id
                                 FROM {$fusion_prefix}ratings r
                                   LEFT JOIN {$fusion_prefix}users u ON (r.rating_user=u.user_id)
                                 WHERE r.rating_type='A'
                                   ORDER BY r.rating_item_id, u.user_name DESC
                              ");

         echo "
         <table>
             <tr>
                 <td>Article</td>
                 <td>Username</td>
                 <td>Rating</td>
                 <td>Deleted</td>
             </tr>
             ";
         while( $row = mysql_fetch_assoc($query) ) {
             $x = mysql_query("SELECT * FROM {$fusion_prefix}ratings r WHERE r.rating_type='A' AND r.rating_user='{$row['user_id']}' AND r.rating_item_id='{$row['rating_item_id']}'");
             if( mysql_num_rows($x) > 1 ) {

                 @mysql_query("DELETE FROM {$fusion_prefix}ratings WHERE rating_id='{$row['rating_id']}' AND rating_type='A'");

                 echo "
                 <tr>
                     <td>{$row['rating_item_id']}</td>
                     <td>{$row['user_name']} ({$row['user_id']}, {$row['rating_id']})</td>
                     <td>".$ratings[$row['vote']]."</td>
                     <td>".mysql_affected_rows()."</td>
                 </tr>";
             }
         }
         echo "</table>";

         closetable();

     }
     // <a href='http://www.hellboundhackers.org/articlecomments.php?article_id={$row['rating_id']}&admin'>{$row['rating_id']}</a>

 } else {
     opentable("HBH Error");
     echo '<center>The article specified does not exist.</center>';
     closetable();
 }

 require_once("side_right.php");
 require_once("footer.php");
?>