<?php
/**
 * /home/public_html/admin/traffic.php
 *
 * Website Traffic Monitor
 *
 * @author Ahmed Chafik
 * @copyright (Mona Lisa [RaC]) 2005
 * @version Define("Id: traffic.php,v 1 2005/08/01 20:25:00 Achafik")
 *
 */

  require_once("includes/common.inc.php");

  $db->Fetch("SELECT * FROM logs", "cnt") or die("There are no records");

  $Mode  = isset($_GET["Mode"]) &&
             preg_match("/^(Main|ShowVisit|ListVisits|Engine|ListRef|ListHost|Browser|OS|Terms|Delete)$/", $_GET["Mode"])
           ? $_GET["Mode"] : "Main";

  $limit = !isset($_GET["limit"]) or !preg_match("/^[-0-9-]+$/i", $_GET["limit"]) ? 15 : $limit;

  echo "
  <head>". (isset($_GET["nostyle"]) ? "" : "
      <style>
          body { background-color: #98AAB1}
          a:link,a:active,a:visited { color : #FFF; }
          a:hover { text-decoration: underline; color : #DD6900; }
          .TableBorder { background-color: #FFFFFF; border: 2px #006699 solid; }
          .fill01 { background-color: #EFEFEF; }
          .fill02 { background-color: #DEE3E7; }
          .fill03 { background-color: #D1D7DC; }
          .HeaderBar { background-image: url(images/cp.gif) }
      </style>") ."
  </head>
  <body>
  <center>";

if(  $Mode == "Main"  )
{
  echo "
  <center>
  <table width=90% border=0 cellpadding=0 cellspacing=0 class=\"TableBorder\">
    <tr>
      <td width=310>
        <table class='sfont' border=0 cellpadding=2 cellspacing=0>
          <tr><td>Report generated for:</td><td><b>". $_SERVER["SERVER_NAME"] ."</b></td></tr>
          <tr><td>Database:</td><td><b>". $db->Name ."</b></td></tr>
          <tr><td>Report generated on:</td><td><b>". date('l m/d/Y g:i a') ."</b></td></tr>
          <tr><td>First log occurred on:</td><td><b>". (date('l m/d/Y g:i a', $db->Fetch("SELECT timestamp FROM logs ORDER BY timestamp ASC  LIMIT 1", "field", "logs", "timestamp"))) ."</b></td></tr>
          <tr><td>Last log occurred at:</td><td><b>".  (date('l m/d/Y g:i a', $db->Fetch("SELECT timestamp FROM logs ORDER BY timestamp DESC LIMIT 1", "field", "logs", "timestamp"))) ."</b></td></tr>
        </table>
      </td>
    </tr>
  </table>\r\n";

  $Totals["2daytt"] = $db->Fetch("SELECT * FROM logs WHERE timestamp <= ".((mktime(0,0,0, date("m"), date("d"), date("Y"))) + (60 * 60 * 24)-1)." and timestamp >= ".(mktime(0, 0, 0, date("m"), date("d"), date("Y"))), "cnt");
  $Totals["2dayun"] = $db->Fetch("SELECT DISTINCT ip FROM logs WHERE timestamp <= ".((mktime(0, 0, 0, date("m"), date("d"), date("Y"))) + (60 * 60 * 24)-1)." and timestamp >= ".(mktime(0, 0, 0, date("m"), date("d"), date("Y"))), "cnt");
  $Totals["visits"] = $db->Fetch("SELECT * FROM logs", "cnt");
  $Totals["unique"] = $db->Fetch("SELECT DISTINCT ip FROM logs", "cnt");

  // ----------------------------------------------------------------------
  // get and sort referring host data
  $Result = $db->Query("SELECT referer FROM logs");

  while($row = mysql_fetch_array($Result))
  {
    $Row = parse_url($row['referer']);
    $refer_set[] = !isset($row['referer']) || $row["referer"] == "None" ? "Direct Hit"
                  : ( $row["referer"] );
  }

  $refer_set = @array_count_values($refer_set);
  arsort($refer_set);

  $top_ref = array_slice($refer_set, 0, 2);
  $top_ref = array_keys($top_ref);

  if($top_ref[0] == 'Direct Hit')
  {
    $top_ref = $top_ref[1];
    $top_ref_count = $refer_set[$top_ref];
  }
  else
  {
    $top_ref = $top_ref[0];
    $top_ref_count = $refer_set[$top_ref];
  }

  echo "
  <br />
  <table width=90% border=0 cellpadding=0 cellspacing=0>
    <tr>
      <td valign='top'>
        <table class='standard' width=475 border=0 cellpadding=2 cellspacing=0>
          <tr><td height=25 class=\"HeaderBar\" colspan=2 align='center'><b>Quick Stats</b></td></tr>
          <tr class='fill01'><td width=250><b>Logged Today</b></td><td width=380><b>".$Totals["2daytt"]."</b></td></tr>
          <tr class='fill02'><td>Unique IP's Logged Today</td><td>".$Totals["2dayun"]."</td></tr>
          <tr class='fill01'><td><b>Total Logs</b></td><td><b>".$Totals["visits"]."</b></td></tr>
          <tr class='fill02'><td>Total Unique IP's Logged</td><td>".$Totals["unique"]."</td></tr>
          <tr class='fill01'><td><b>Top Referring Host</b></td><td><b>". substr($top_ref, 0, 22)."</b> ( ".number_format($top_ref_count)." )</td></tr>
          <tr class='fill02'><td>Top Search Engine</td><td>". ( isset($top_engine) ? (($top_engine[0]." ( ".number_format($top_engine_count)." )")) : "None" )."</td></tr>
          <tr class='fill01'><td colspan=7 height=3></td></tr>
        </table>
      </td>
      <td align='right' valign='top'>
        <table border=0 cellpadding=2 cellspacing=0>
          <tr><td height=25 class=\"HeaderBar\" colspan=7 align='center'><b>".date("F Y")."</b></td></tr>
          <tr class='fill03'>
            <td height=20 align='center'><b>Sun</b></td>
            <td align='center'><b>Mon</b></td>
            <td align='center'><b>Tue</b></td>
            <td align='center'><b>Wed</b></td>
            <td align='center'><b>Thu</b></td>
            <td align='center'><b>Fri</b></td>
            <td align='center'><b>Sat</b></td>
          </tr>";

        $MonthStart = date("w", mktime(0,0,0,date("m"),1,date("Y"))); // DETERMINE THE FIRST DAY OF THE WEEK
        $MonthStart = $MonthStart == 0 ? 7 : $MonthStart;

        $LastDay  = date("d", mktime(0,0,0,date("m")+1,0,date("Y")));
        $StartDay = -$MonthStart;

        for($n = 1; $n <= 5; $n++)
        {
         echo "<tr>";

          for($i = 1; $i <= 7; $i++)
          {

            $StartDay++;

            if(($StartDay <= 0) || ($StartDay > $LastDay))
              echo "<td class=\"fill02\">&nbsp;</td>";

            elseif($StartDay == date("j"))
              echo "<td class=\"fill03\" align=\"center\"><b>". $StartDay ."</b></td>";

            elseif(($StartDay >= 1) && ($StartDay <= $LastDay))
              echo "<td align=\"center\" class=\"fill02\">". $StartDay ."</td>";

          }

         echo "</tr>";
        }

  echo "
          <tr class='fill01'><td colspan=7 height=5></td></tr>
        </table>
      </td>
      <td colspan=2 height=5 class='fill02'></td>
    </tr>
  </table>
  <br/>
  " /* - Start Addition For 25 Day Summary Here - */ ."
  <table width=90% border=0 cellpadding=0 cellspacing=0 class=\"TableBorder\">
    <tr class='fill01'><td height=25 colspan=25 class=\"HeaderBar\" align='center'><b>25 Day Summary - Number of Logs</b></td></tr>
      <tr>";


  for($n = 24; $n >= 0; $n--)
  {

    $timestamp  = mktime(0, 0 ,0, date("m"), date("d")-$n, date("Y"));
    $Result     = $db->Fetch("SELECT * FROM logs WHERE timestamp <= ".($timestamp+86399)." and timestamp >= ".$timestamp, "cnt");
    $Graph[]    = array(date("d", $timestamp), substr(date("D", $timestamp), 0, 1), $Result);

    if( !isset($high) || $Result > $high) $high = $Result;

  }


  foreach($Graph as $Line)
  {
    $height = round(100 *  (isset($high) ? ($Line[2]/($high == 0 ? 1 : $high)) : 0)  );

    echo "
    <td class='standard' width=22 align='center' valign='bottom'>
      $Line[2]<img src='images/gv.jpg' width=16 height=". ($height) .">
    </td>\r\n";
  }

  echo "</tr><tr class=\"fill03\">";

  foreach($Graph as $Line)
    echo "<td align='center'>$Line[0]</td>";

  echo "</tr><tr class=\"fill02\">";

  foreach($Graph as $Line)
    echo "<td class='Text' align='center'>$Line[1]</td>";
  unset($Graph, $Line);

  echo "
	</tr>
	<tr class='fill03'><td colspan=30 height=5></td></tr>
  </table>
  <br />
  " /* - Start Addition For 25 Day Summary of Unique IPs logged Here - */ ."
  <table width=90% border=0 cellpadding=0 cellspacing=0 class=\"TableBorder\">
    <tr class='fill01'><td height=25 colspan=25 class=\"HeaderBar\" align='center'><b>25 Day Summary - Unique IPs Logged</b></td></tr>
      <tr>";


  for($n = 24; $n >= 0; $n--)
  {

    $timestamp  = mktime(0, 0 ,0, date("m"), date("d")-$n, date("Y"));
    $Result     = $db->Fetch("SELECT DISTINCT ip FROM logs WHERE timestamp <= ".($timestamp+86399)." and timestamp >= ".$timestamp, "cnt");
    $Graph[]    = array(date("d", $timestamp), substr(date("D", $timestamp), 0, 1), $Result);

    if( !isset($high) || $Result > $high) $high = $Result;

  }


  foreach($Graph as $Line)
  {
    $height = round(100 *  (isset($high) ? ($Line[2]/($high == 0 ? 1 : $high)) : 0)  );

    echo "
    <td class='standard' width=22 align='center' valign='bottom'>
      ". str_pad($Line[2], 3, 0, "LEFT")."<img src='images/gv.jpg' width=16 height=". ($height) .">
    </td>\r\n";
  }

  echo "</tr><tr class=\"fill03\">";

  foreach($Graph as $Line)
    echo "<td align='center'>$Line[0]</td>";

  echo "</tr><tr class=\"fill02\">";

  foreach($Graph as $Line)
    echo "<td class='Text' align='center'>$Line[1]</td>";

  echo "
	</tr>
	<tr class='fill03'><td colspan=30 height=5></td></tr>
  </table>
  <br />
  " /* - Start Addition For Last 10 Logs Here - */ ."
  <table class=\"TableBorder\" width=90% border=0 cellpadding=2 cellspacing=0>
    <tr class='fill01'>
      <td height=25 class=\"HeaderBar\" colspan=7 align='center'>
        <b>Last 10 Logs</b> (
        <a class=\"Text\" href='traffic.php?Mode=ListVisits&Type=Today'>Today</a>
         |
        <a class=\"Text\" href='traffic.php?Mode=ListVisits&Limit=100'>Last 100</a>
         |
        <a class=\"Text\" href='traffic.php?Mode=ListVisits'>List All</a> )
      </td>
    </tr>
    <tr class='fill01'>
      <td width=130 align='center'><b>Date / Time</b></td>
      <td width=95 align='center'><b>IP</b></td>
      <td width=55 align='center'><b>System</b></td>
      <td><b>Referring Host</b></td>
      <td><b>Entry Page</b></td>
      <td width=20></td>
    </tr>";

    $LastTen = $db->Query(" SELECT l.*
                            FROM logs l
                           ORDER BY l.timestamp DESC
                            LIMIT 0,10");

    unset($n);
    while ( $Data = mysql_fetch_array($LastTen) )
    {
     @$n++;

      $clip_page = substr($Data["page"], 0, 18);
      $browser   = $Log->Browser2Img($Log->GetBrowser($Data['browser']));
      $os        = $Log->Os2Img($Log->GetOs($Data['os']));

      $Data["referer"] = preg_match("/^(http:\/\/)/", $Data["referer"]) ? $Data["referer"] : "http://".$Data["referer"];
      $Data["referer"] = parse_url($Data["referer"]);

      echo "
      <tr class=\"fill0". (   ($n % 2) ? 2 : 1   ) ."\">
        <td align='center'>". date("l m/d/Y g:i a", $Data['timestamp'])."</td>
        <td align='center'>$Data[ip]</td>
        <td align='center'><img src='$browser'> <img src='$os'></td>
        <td>". substr(@$Data["referer"]["host"], 0, 100) ."</td>
        <td>$clip_page</td>
        <td align='right'><a href='traffic.php?Mode=ShowVisit&id=$Data[id]'><img src='images/info.jpg' border=0></a></td>
      </tr>";
    }

  echo "
      <tr class='fill01'><td colspan=7 height=5></td></tr>
  </table>
  <br />
  " /* - Start Addition For Web Browser Summary Here - */ ."
  <table class=\"TableBorder\" width=90% border=0 cellpadding=2 cellspacing=0>
    <tr class='fill01'><td height=25 colspan=25 class=\"HeaderBar\" align='center'><b>Web Browser Summary</b></td></tr>";

  // ----------------------------------------------------------------------
  // get and sort browser data
  $result = $db->Query("SELECT browser FROM logs");

  while($row = mysql_fetch_array($result))
    $bset[] = trim($row['browser']) == "" ? "Unknown" : $row['browser'];

  $bset             = array_count_values($bset);
  arsort($bset);
  $TopBrowser       = array_slice($bset, 0, 2);
  $TopBrowserCount  = $TopBrowser;
  $TopBrowser       = array_keys($TopBrowser);

  if($TopBrowser[0] == 'Unknown')
  {
    $TopBrowser      = $TopBrowser[1];
    $TopBrowserCount = $TopBrowserCount[$TopBrowser];
  }
  else
  {
    $TopBrowser      = $TopBrowser[0];
    $TopBrowserCount = $TopBrowserCount[$TopBrowser];
  }

  unset($n);
  foreach($bset as $name => $value)
  {
   @$n++;

    $percent = round((  $value / $Totals["visits"]  ) * 100, 1);

    echo "
    <tr ". (($n%2) ? "class=\"fill03\"" : "") .">
      <td width=120>$name</td>
      <td valign='middle'>
        <img src='". $Log->Browser2Img($Log->GetBrowser($name)) ."' align='absmiddle'>&nbsp;&nbsp;
        <img src='images/gh.jpg' width=". round(($percent*275)/100) ." height=16> $percent% ($value)</td>


      <td align='right'><a href='traffic.php?Mode=Browser&Name=$name'><img src='images/info.jpg' border=0></a></td>
    </tr>";
  }
  echo "
    <tr class='fill01'><td colspan=3 height=5></td></tr>
  </table>
  <br />
  " /* - Start Addition For Operating System Summary Here - */ ."
  <table class=\"TableBorder\" width=90% border=0 cellpadding=2 cellspacing=0>
    <tr class='fill01'><td height=25 colspan=25 class=\"HeaderBar\" align='center'><b>Operating System Summary</b></td></tr>";

  // ----------------------------------------------------------------------
  // get and sort os data
  $result = $db->Query("SELECT os FROM logs");

  while($row = mysql_fetch_array($result))
    $oset[] = trim($row['os']) == "" ? "Unknown" : $row['os'];

  $oset             = array_count_values($oset);
  arsort($oset);
  $Topos       = array_slice($oset, 0, 2);
  $ToposCount  = $Topos;
  $Topos       = array_keys($Topos);

  if($Topos[0] == 'Unknown')
  {
    $Topos      = $Topos[1];
    $ToposCount = $ToposCount[$Topos];
  }
  else
  {
    $Topos      = $Topos[0];
    $ToposCount = $ToposCount[$Topos];
  }

  unset($n);
  foreach($oset as $name => $value)
  {
   @$n++;
    $percent = round((  $value / $Totals["visits"]  ) * 100, 1);

    echo "
    <tr ". (($n%2) ? "class=\"fill03\"" : "") .">
      <td width=120>$name</td>
      <td valign='middle'>
        <img src='". $Log->os2Img($Log->Getos($name)) ."' align='absmiddle'>&nbsp;&nbsp;
        <img src='images/gh.jpg' width=". round(($percent*275)/100) ." height=16> $percent% ($value)</td>


      <td align='right'><a href='traffic.php?Mode=OS&Name=$name'><img src='images/info.jpg' border=0></a></td>
    </tr>";
  }
  echo "
    <tr class='fill01'><td colspan=3 height=5></td></tr>
  </table>
  <br />
  " /* - Start Addition For Top 10 Referers & Hosts Here - */ ."
  <table class=\"TableBorder\" width=90% border=0 cellpadding=2 cellspacing=0>
    <tr>
      <td valign='top'>
        <table width=100% border=0 cellpadding=2 cellspacing=0>
          <tr><td height=25 colspan=5 class=\"HeaderBar\" align='center'><b>Top 10 Referrers</b> ( <a class='Text' href='traffic.php?Mode=ListRef'>List All</a> )</td></tr>
          <tr class='fill01'>
            <td width=210><b>Referring URL</b></td>
            <td width=75 align='right'><b>Hits</b></td>
            <td width=40 align='right'><b>%</b></td>
          </tr>";

            $refer_set = array_slice($refer_set, 0, 10);

            unset($n);
            foreach($refer_set as $ref => $hits)
            {
             @$n++;

              $Class = ($n % 2) ? "class=\"Text\"" : "";

              echo "
              <tr class=\"fill0". (   ($n % 2) ? 2 : 1   ) ."\">
                <td {$Class}>". substr($ref, 0, 30) ."</td>
                <td {$Class} align='right'>". (int) $hits ."</td>
                <td {$Class} align='right'>". round(($hits / $Totals["visits"]) * 100, 2) ."%</td>
              </tr>";

            }
          echo "
          <tr class='fill01'><td colspan=3 height=5></td></tr>
        </table>
      </td>

      <td valign='top'>
        <table width=100% border=0 cellpadding=2 cellspacing=0>
          <tr><td height=25 colspan=5 class=\"HeaderBar\" align='center'><b>Top 10 Hosts</b> ( <a class='Text' href='traffic.php?Mode=ListHost'>List All</a> )</td></td></tr>
          <tr class='fill01'>
            <td width=210><b>Host</b></td>
            <td width=75 align='right'><b>Hits</b></td>
            <td width=40 align='right'><b>%</b></td>
          </tr>";

            // ----------------------------------------------------------------------
            // get and sort host data
            $result = mysql_query("SELECT host FROM logs WHERE host!=''");
            $hset = array();

            while($row = mysql_fetch_array($result))
            	if(trim($row['host'] != "")) array_push($hset, $row['host']);

            $hset = array_count_values($hset);
            arsort($hset);

            $hset = array_slice($hset, 0, 10);

            unset($n);
            foreach($hset as $host => $hits)
            {
             @$n++;

              $Class = ($n % 2) ? "class=\"Text\"" : "";

              echo "
              <tr class=\"fill0". (   ($n % 2) ? 2 : 1   ) ."\">
                <td {$Class}>". substr($host, 0, 30) ."</td>
                <td {$Class} align='right'>". number_format($hits) ."</td>
                <td {$Class} align='right'>". round(($hits / $Totals["visits"]) * 100, 2) ."%</td>
              </tr>";

            }

          echo "
          <tr class='fill01'><td colspan=3 height=5></td></tr>
        </table>
      </td>
    </tr>
  </table>
  <br />
  ";

}



















if(  $Mode == "ShowVisit"  )
{

  $Data = $db->Fetch("SELECT l.*, u.user_name as uname
                       FROM logs l
                         LEFT JOIN hbh_users u ON (l.uid=u.user_id)
                      WHERE l.id=". (int) $_GET["id"]);

  if(isset($Data['browser'])) $browser_image = "<img src='".$Log->Browser2Img($Data['browser'])."'>";
  if(isset($Data['os']))      $os_image      = "<img src='".$Log->Os2Img($Data['os'])."'>";
  if(isset($Data['engine']))  $engine_image  = "<img src='".$Log->Engine2Img($Data['engine'])."'>";


  echo "
  <table class='standard' width=550 border=0 cellpadding=2 cellspacing=0>
    <tr class='fill01'><td height=25 class=\"HeaderBar\" colspan=2 align='center'><b>Complete Visit Details</b></td></tr>

    <tr class=\"fill01\">
      <td width=20%><b>User ID</b></td>
      <td>".$Data['uid']."</td>
    </tr>
    <tr class=\"fill01\">
      <td width=20%><b>Username</b></td>
      <td>{$Data['uname']}</td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Action</b></td>
      <td>".$Data['action']."</td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\"><b>Outcome</b></td>
      <td class=\"Text\">".$Data['outcome']."</td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Time Logged</b></td>
      <td><b>". date("l m/d/Y g:i a", $Data['timestamp']) ."</b></td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\"><b>IP Address</b></td>
      <td class=\"Text\">".$Data['ip']."</td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Host</b></td>
      <td>".$Data['host']."</td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\"><b>Browser</b></td>
      <td class=\"Text\">".$Data['browser']." $browser_image</td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Operating System</b></td>
      <td>".$Data['os']." $os_image</td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\">Client String</td>
      <td class=\"Text\">$Data[client]</td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Referring Host</b></td>
      <td>$Data[referer_host]</td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\">Referrer String</td>
      <td class=\"Text\"><a class='Text' href='$Data[referer]' target='_blank'>$Data[referer]</a></td>
    </tr>
    <tr class=\"fill01\">
      <td><b>Search Engine</b></td>
      <td>$Data[engine] $engine_image</td>
    </tr>
    <tr class=\"fill02\">
      <td class=\"Text\"><b>Search Query</b></td>
      <td class=\"Text\">". urldecode($Data['terms']) ."</td>
    </tr>
    <tr class=\"fill01\">
      <td> Entry Page</td>
      <td>$Data[page]</td>
    </tr>

    <tr class='fill02'><td colspan=2 height=5></td></tr>
  </table>\r\n";
}




















if(  $Mode == "ListVisits"  )
{
  $Types = array("Today" => "Today's Logs");

  echo "
  <center>
  <table class=\"TableBorder\" width=90% border=0 cellpadding=2 cellspacing=0>
    <tr class='fill01'>
      <td height=25 class=\"HeaderBar\" colspan=8 align='center'>
        <b>".$_SERVER["SERVER_NAME"]." Logs (Viewing: ". (isset($Types[@$_GET["Type"]]) ? $Types[$_GET["Type"]] : "Default View") .")</b>
      </td>
    </tr>
    <tr class='fill01'>
      <td width=130 align='center'><b>Date / Time</b></td>
      <td width=95 align='center'><b>IP</b></td>
      <td width=55 align='center'><b>System</b></td>
      <td><b>Referring Host</b></td>
      <td><b>Entry Page</b></td>
      <td width=20></td>
      ". /*($User->Check("Owner") ? "<td width=20></td>" : "") . */"
      <td width=20></td>
    </tr>";

    $TodayStart = mktime(0, 0, 0);
    $Typesa     = array("Today" => "WHERE timestamp >= {$TodayStart} and timestamp <= ".($TodayStart+86399));

    @$Extra = isset($_GET["Type"]) ? $Typesa[$_GET["Type"]] : "";

    $LastTen = $db->Query(" SELECT l.*
                            FROM logs l
                           ". @$Extra ."
                           ORDER BY l.timestamp DESC
                            LIMIT 0,". (( isset($_GET["Limit"]) ? (int) $_GET["Limit"] : 1000  )));

    unset($n);
    while ( $Data = mysql_fetch_array($LastTen) )
    {
     @$n++;

      $clip_page = substr($Data["page"], 0, 55);
      $browser   = $Log->Browser2Img($Log->GetBrowser($Data['browser']));
      $os        = $Log->Os2Img($Log->GetOs($Data['os']));

      $Data["referer"] = preg_match("/^(http:\/\/)/", $Data["referer"]) ? $Data["referer"] : "http://".$Data["referer"];
      $Data["referer"] = parse_url($Data["referer"]);

      echo "
      <tr class=\"fill0". (   ($n % 2) ? 2 : 1   ) ."\">
        <td align='center'>". date("l m/d/Y g:i a", $Data['timestamp'])."</td>
        <td align='center'>$Data[ip]</td>
        <td align='center'><img src='$browser'> <img src='$os'></td>
        <td>". substr(  ( isset($Data["referer"]["host"]) ? $Data["referer"]["host"] : "None" ), 0, 100) ."</td>
        <td>$clip_page</td>
        <td align='right'><a href='traffic.php?Mode=ShowVisit&id=$Data[id]'><img src='images/info.jpg' border=0></a></td>
        ". /*($User->Check("Owner") ? "<td align='right'><a href='traffic.php?Mode=Delete&id=$Data[id]'><img src='images/delete.png' border=0></a></td>" : "" ) .*/ "
        <td align='right'><a href='traffic.php?Mode=Delete&id=$Data[id]'><img src='images/delete.png' border=0></a></td>
      </tr>";
    }

  echo "
      <tr class='fill01'><td colspan=7 height=5></td></tr>
  </table>";

}
















if(  $Mode == "ListRef"  )
{
  $Result = $db->Query("SELECT referer FROM logs");
  $Totals["visits"] = mysql_num_rows($Result);
  $refer_set = array();

  while($row = mysql_fetch_array($Result))
  {
    if(!$row['referer']) { $row['referer'] = "Direct Hit"; }
    array_push($refer_set, $row['referer']);
  }

  $refer_set = array_count_values($refer_set);
  arsort($refer_set);

  echo "
  <table class='TableBorder' width=550 border=0 cellpadding=2 cellspacing=0>
    <tr><td height=25 class=\"HeaderBar\" colspan=5 align='center'><b>Referrers</b> ( Percentage is based on total visits logged. )</td></tr>
      <tr class='fill01'>
      <td width=545><b>Referring URL</b></td>
      <td width=75 align='right'><b>Hits</b></td>
      <td width=40 align='right'><b>%</b></td>
    </tr>";

  unset($n);
  foreach($refer_set as $ref => $hits)
  {
   @$n++;

    echo "
    <tr ".(   ($n % 2) ? "class='fill03'" : ""    ).">
      <td height=20>$ref</td>
      <td align='right'>". number_format($hits) ."</td>
      <td align='right'>". round(($hits / str_replace(',', '', $Totals["visits"])) * 100) ."%</td>
    </tr>\r\n";

  }

  echo "
    <tr class='fill01'><td colspan=3 height=5></td></tr>
  </table>\r\n";

}














if(  $Mode == "ListHost"  )
{
  $Result = $db->Query("SELECT host FROM logs");
  $Totals["visits"] = mysql_num_rows($Result);
  $host_set = array();

  while($row = mysql_fetch_array($Result))
  {
    if(!$row['host']) { $row['host'] = "Unknown"; }
    array_push($host_set, $row['host']);
  }

  $host_set = array_count_values($host_set);
  arsort($host_set);

  echo "
  <table class='TableBorder' width=550 border=0 cellpadding=2 cellspacing=0>
    <tr><td height=25 class=\"HeaderBar\" colspan=5 align='center'><b>Hosts</b> ( Percentage is based on total visits logged. )</td></tr>
      <tr class='fill01'>
      <td width=545><b>Host</b></td>
      <td width=75 align='right'><b>Hits</b></td>
      <td width=40 align='right'><b>%</b></td>
    </tr>";

  unset($n);
  foreach($host_set as $host => $hits)
  {
   @$n++;

    echo "
    <tr ".(   ($n % 2) ? "class='fill03'" : ""    ).">
      <td height=20>$host</td>
      <td align='right'>". number_format($hits) ."</td>
      <td align='right'>". round(($hits / $Totals["visits"]) * 100) ."%</td>
    </tr>\r\n";

  }

  echo "
    <tr class='fill01'><td colspan=3 height=5></td></tr>
  </table>\r\n";

}













if(  $Mode == "Browser"  )
{
  $name   = isset($_GET["Name"]) ? $_GET["Name"] : "Null";

  $Result = $db->Query(" SELECT l.*
                          FROM logs l
                         WHERE l.browser='$name'
                         ORDER BY l.timestamp DESC");

  echo "
  <table class='TableBorder' width=550 border=0 cellpadding=2 cellspacing=0>
    <tr><td height=25 class=\"HeaderBar\" colspan=6 align='center'><b>Clients Using $name</b></td></tr>
    <tr class='fill01'>
      <td width=90 align='center'><b>Date/Time</b></td>
      <td width=45 align='center'><b>IP</b></td>
      <td width=55 align='center'><b>System</b></td>
      <td width=355 align='center'><b>Client String</b></td>
      <td width=20></td>
    </tr>\r\n";


  while($Data = mysql_fetch_array($Result))
  {
   @$n++;

    $os                = $Log->Os2Img($Log->GetOs($Data['os']));
    $Data['terms']     = urldecode($Data['terms']);

    echo "
    <tr ".(   ($n % 2) ? "class='fill03'" : ""    ).">
      <td height=20 align='center'>". date("m/d/Y h:i a", $Data['timestamp']) ."</td>
      <td align='center'>$Data[ip]</td>
      <td align='center'><img src='". $Log->Browser2Img($Log->GetBrowser($Data['browser'])) ."'> <img src='$os'></td>
      <td align='center'>$Data[client]</td>
      <td align='right'><a href='traffic.php?Mode=ShowVisit&id=$Data[id]'><img src='images/info.jpg' border=0></a></td>
    </tr>\r\n";

  }

  echo "
    <tr class='fill01'><td colspan=6 height=5></td></tr>
  </table>";

}











if(  $Mode == "OS"  )
{
  $name   = isset($_GET["Name"]) ? $_GET["Name"] : "Null";

  $Result = $db->Query(" SELECT l.*
                          FROM logs l
                         WHERE l.os='$name'
                         ORDER BY l.timestamp DESC");

  echo "
  <table class='TableBorder' width=550 border=0 cellpadding=2 cellspacing=0>
    <tr><td height=25 class=\"HeaderBar\" colspan=6 align='center'><b>Clients Using $name</b></td></tr>
    <tr class='fill01'>
      <td width=90 align='center'><b>Date/Time</b></td>
      <td width=45 align='center'><b>IP</b></td>
      <td width=55 align='center'><b>System</b></td>
      <td width=355 align='center'><b>Client String</b></td>
      <td width=20></td>
    </tr>\r\n";


  while($Data = mysql_fetch_array($Result))
  {
   @$n++;

    $os                = $Log->Os2Img($Log->GetOs($Data['os']));
    $Data['terms']     = urldecode($Data['terms']);

    echo "
    <tr ".(   ($n % 2) ? "class='fill03'" : ""    ).">
      <td height=20 align='center'>". date("m/d/Y h:i a", $Data['timestamp']) ."</td>
      <td align='center'>$Data[ip]</td>
      <td align='center'><img src='". $Log->Browser2Img($Log->GetBrowser($Data['browser'])) ."'> <img src='$os'></td>
      <td align='center'>$Data[client]</td>
      <td align='right'><a href='traffic.php?Mode=ShowVisit&id=$Data[id]'><img src='images/info.jpg' border=0></a></td>
    </tr>\r\n";

  }

  echo "
    <tr class='fill01'><td colspan=6 height=5></td></tr>
  </table>";

}




if(  $Mode == "Delete"  )
{
  $id = isset($_GET["id"]) ? (int) $_GET["id"] : DisplayError("No Log has Been Selected for Deletion", "Error: ", TRUE);

  $testlog = $db->Fetch("SELECT * FROM logs WHERE id=".$id, "cnt") > 0 ? TRUE : DisplayError("Invalid Log ID", "Error: ", TRUE);

  if ($_GET["confirm"] != "yes")
  {
    echo "<center>Are You Sure You Want To Delete Log Number $id?<br />
    <a href=traffic.php?Mode=Delete&id=$id&confirm=yes>Yes</a> | <a href=traffic.php?Mode=ShowVisit&id={$id}>No</a></center>";
  }

  else
  {
    echo "<center>Log #{$id} Deleted</center>";
    $db->Query("DELETE FROM logs WHERE id=".$id);
  }

}



if ($Mode != "Main")
  echo "<br /><center><a href=traffic.php?>Back To Web Traffic</a></center>";


?>